#!/bin/sh
#
# This goes in /usr/local/etc/rc.d and gets run at boot-time.

PATH_ACPID=/bin/acpid

case "$1" in

start)
    if [ -x "$PATH_ACPID" ] ; then
            insmod /lib/modules/button.ko
            insmod /lib/modules/evdev.ko
            echo "start acpid"
            $PATH_ACPID
            logger -p daemon.info "$0 started acpid"
    fi
    ;;

stop)
    echo "stop acpid"
    killall acpid > /dev/null 2>&1
    logger -p daemon.info "$0 stopped acpid"
    ;;

*)
    echo "usage: $0 { start | stop }" >&2
    exit 1
    ;;

esac

